/* 
 *  ExtendWrapupRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;

import javafx.concurrent.WorkerStateEvent;

public class ExtendWrapupRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(ExtendWrapupRequest.class);

    public ExtendWrapupRequest(String interactionID) {
        super(LOG, interactionID);
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().extendWrapup();
        LOG.trace(methodName + "-");
        return null;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            LOG.trace(methodName + " Extending wrapup timer");
            // Upon successful request to extend timer add timer to existing
            // running timer
            InteractionExecutor.getTimers().extendWrapUP(getInteractionID());
        });
    }
}
